/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipch.OipchUnixBooleanMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixNumberMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixPartition;
import oracle.sysman.oip.oipc.oipch.OipchUnixStringMountParameter;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class DiskFixes {
    public static final String SEPARATOR = "%";
    public static final String COMMA = ",";
    public static final String MOUNT_INFO = "MOUNT_INFO";
    public static final String ENABLE_MOUNT = "ENABLE_MOUNT";
    public static final String BLANK = " ";
    public static final String APOSTROPHE = "\"";
    public static final String EQUALS = "=";
    public static final String ENABLE_STRING = "\"true\"";

    public static OipcfFixUpResult fixMountParameters(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult;
        }
        ArrayList<String> oMountInfoList = new ArrayList<String>();
        Iterator iter = null;
        if (res != null) {
            iter = res.getResultDetails();
        } else {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult;
        }
        while (iter.hasNext()) {
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            int nResult = oResultDetails.getResult();
            if (nResult != 7) continue;
            OipchUnixPartition oExpectedResult = (OipchUnixPartition)oResultDetails.getExpectedData();
            if (oExpectedResult == null) {
                OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            String sDeviceName = oExpectedResult.getDevice();
            String sMountPoint = oExpectedResult.getMount();
            String sType = oExpectedResult.getType();
            List oMountParams = oExpectedResult.getParams();
            StringBuffer oSb = new StringBuffer();
            oSb.append(sType);
            oSb.append(SEPARATOR);
            oSb.append(sDeviceName);
            oSb.append(SEPARATOR);
            oSb.append(sMountPoint);
            oSb.append(SEPARATOR);
            for (int i = 0; i < oMountParams.size(); ++i) {
                String sParamName;
                OipchUnixMountParameter oMountParam = (OipchUnixMountParameter)oMountParams.get(i);
                if (oMountParam instanceof OipchUnixBooleanMountParameter) {
                    sParamName = oMountParam.getName();
                    Boolean bValue = (Boolean)oMountParam.getValue();
                    if (!bValue.booleanValue()) continue;
                    oSb.append(sParamName);
                    oSb.append(COMMA);
                    continue;
                }
                if (oMountParam instanceof OipchUnixNumberMountParameter) {
                    sParamName = oMountParam.getName();
                    Long oLongVal = (Long)oMountParam.getValue();
                    if (oLongVal == null) continue;
                    oSb.append(sParamName);
                    oSb.append(EQUALS);
                    oSb.append(oLongVal.toString());
                    oSb.append(COMMA);
                    continue;
                }
                if (!(oMountParam instanceof OipchUnixStringMountParameter)) continue;
                sParamName = oMountParam.getName();
                String sVal = (String)oMountParam.getValue();
                if (sVal == null) continue;
                oSb.append(sParamName);
                oSb.append(EQUALS);
                oSb.append(sVal);
                oSb.append(COMMA);
            }
            oMountInfoList.add(oSb.toString());
        }
        try {
            DiskFixes.instantiateResponseFile(sResponseFile, oMountInfoList, MOUNT_INFO);
            DiskFixes.instantiateEnableFile(sEnableFile, ENABLE_MOUNT);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateResponseFile(String sResponseFile, List contentsList, String sFeature) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        String sValue = "";
        for (int i = 0; i < contentsList.size(); ++i) {
            sValue = sValue + contentsList.get(i);
            sValue = sValue + BLANK;
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(sFeature)) continue;
            line = sFeature + EQUALS + APOSTROPHE + sValue + APOSTROPHE;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = sFeature + EQUALS + APOSTROPHE + sValue + APOSTROPHE;
            fileContentsList.add(line);
        }
        try {
            DiskFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateEnableFile(String sEnableFile, String sFeature) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(sFeature)) continue;
            line = sFeature + EQUALS + ENABLE_STRING;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = sFeature + EQUALS + ENABLE_STRING;
            fileContentsList.add(line);
        }
        try {
            DiskFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

